/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.binary2;

import cds.savot.binary.Base64InputStream;
import cds.savot.binary.SavotDataReader;
import cds.savot.model.FieldSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotStream;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.TDSet;
import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;

public final class DataBinary2Reader
implements SavotDataReader {
    private static final String URL_REGEXP = "^(http(s|g)?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private static final DateFormat EXPIRES_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private InputStream data;
    private BinaryFieldInterpreter<?>[] decoders;
    private Object[] row;
    private boolean nextCalled = false;
    private boolean eof = false;
    private int nullBytes = 0;

    public DataBinary2Reader(SavotStream stream, FieldSet fields) throws IOException {
        this(stream, fields, false, null);
    }

    public DataBinary2Reader(SavotStream stream, FieldSet fields, boolean ignoreExpiryDate) throws IOException {
        this(stream, fields, ignoreExpiryDate, null);
    }

    public DataBinary2Reader(SavotStream stream, FieldSet fields, boolean ignoreExpiryDate, String parentDirectory) throws IOException {
        this(fields);
        this.data = this.getData(stream, ignoreExpiryDate, parentDirectory);
    }

    public DataBinary2Reader(InputStream encodedData, String encoding, FieldSet fields) throws IOException {
        this(fields);
        this.data = this.getDecodedStream(encodedData, encoding);
    }

    public DataBinary2Reader(InputStream decodedData, FieldSet fields) throws BinaryInterpreterException {
        this(fields);
        this.data = decodedData;
    }

    protected DataBinary2Reader(FieldSet fields) throws BinaryInterpreterException {
        int i;
        int nFields = fields.getItemCount();
        this.nullBytes = (fields.getItemCount() + 7) / 8;
        for (int identNull = 0; identNull < this.nullBytes; ++identNull) {
            SavotField thenull = new SavotField();
            thenull.setDataType("unsignedByte");
            thenull.setName("NullByte" + identNull);
            fields.set.add(identNull, thenull);
        }
        this.decoders = new BinaryFieldInterpreter[nFields += this.nullBytes];
        for (i = 0; i < nFields; ++i) {
            this.decoders[i] = BinaryFieldInterpreter.createInterpreter((SavotField)fields.getItemAt(i));
        }
        for (i = 0; i < this.nullBytes; ++i) {
            fields.removeItemAt(0);
        }
        this.row = new Object[nFields];
    }

    private InputStream getData(SavotStream stream, boolean ignoreExpiryDate, String parentDirectory) throws IOException {
        String expires;
        if (!ignoreExpiryDate && stream.getExpires() != null && !(expires = stream.getExpires().trim()).isEmpty()) {
            try {
                Date expiryDate = EXPIRES_DATE_FORMAT.parse(expires);
                if (expiryDate.before(new Date())) {
                    throw new IOException("Data are not valid any more (expiry date: \"" + expires + "\") !");
                }
            }
            catch (ParseException pe) {
                System.out.println("Warning: unknown date format (" + expires + "): the stream expiry date will be ignored !");
            }
        }
        InputStream data = null;
        String encoding = stream.getEncoding() == null ? null : stream.getEncoding().trim();
        String href = stream.getHref();
        if (href != null && !href.trim().isEmpty()) {
            if ((href = href.trim()).matches(URL_REGEXP)) {
                URL url = new URL(href);
                data = this.getInputFromURL(url, stream.getRights());
                if (encoding != null && encoding.equalsIgnoreCase("dynamic")) {
                    try {
                        encoding = this.getDynamicEncoding(url, stream.getRights());
                    }
                    catch (IOException ioe) {
                        throw new IOException("Can't fetch the data encoding from the URL \"" + href + "\", because: " + ioe.getMessage(), ioe);
                    }
                }
            } else {
                File dataFile = parentDirectory == null ? new File(href) : new File(parentDirectory, href);
                data = new FileInputStream(dataFile);
            }
        } else {
            data = new ByteArrayInputStream(stream.getContent().getBytes());
        }
        data = this.getDecodedStream(data, encoding);
        return data;
    }

    private InputStream getInputFromURL(URL dataUrl, String rights) throws IOException {
        return dataUrl.openStream();
    }

    private String getDynamicEncoding(URL dataUrl, String rights) throws IOException {
        URLConnection connection = dataUrl.openConnection();
        connection.connect();
        return connection.getContentEncoding();
    }

    private InputStream getDecodedStream(InputStream encodedStream, String encoding) throws IOException {
        if (encoding == null || encoding.isEmpty()) {
            return encodedStream;
        }
        if (encoding.equalsIgnoreCase("base64")) {
            return new Base64InputStream(encodedStream);
        }
        if (encoding.equalsIgnoreCase("gzip")) {
            return new GZIPInputStream(encodedStream);
        }
        throw new BinaryInterpreterException("Unknown encoding \"" + encoding + "\" ! It must be either \"base64\" or \"gzip\" !");
    }

    @Override
    public boolean next() throws IOException {
        if (this.row == null) {
            throw new IOException("Reader closed !");
        }
        if (this.eof) {
            return false;
        }
        for (int i = 0; i < this.row.length; ++i) {
            this.row[i] = this.decoders[i].decode(this.data);
            if (this.row[i] != null) continue;
            if (i == 0) {
                this.eof = true;
                this.nextCalled = true;
                return false;
            }
            throw new IOException("Unexpected EOF: the row has not been read completely ; only " + i + " columns on " + this.row.length + " has been successfully read !");
        }
        this.nextCalled = true;
        return true;
    }

    private void ensureRowAvailable() throws IllegalStateException {
        if (this.row == null) {
            throw new IllegalStateException("No more row available: the reader is closed !");
        }
        if (this.eof) {
            throw new IllegalStateException("No more row available: the end of file has been reached !");
        }
        if (!this.nextCalled) {
            throw new IllegalStateException("No row available: next() has not yet been called !");
        }
    }

    @Override
    public Object[] getRow() throws IllegalStateException {
        this.ensureRowAvailable();
        return this.row;
    }

    @Override
    public SavotTR getTR() throws IllegalStateException {
        this.ensureRowAvailable();
        SavotTR tr = new SavotTR();
        TDSet tds = new TDSet();
        for (int i = 0; i < this.row.length; ++i) {
            tds.addItem(this.getTD(i));
        }
        tr.setTDs(tds);
        return tr;
    }

    @Override
    public Object getCell(int indColumn) throws IndexOutOfBoundsException, IllegalStateException {
        this.ensureRowAvailable();
        return this.row == null ? null : this.row[indColumn + this.nullBytes];
    }

    @Override
    public String getCellAsString(int indColumn) throws IndexOutOfBoundsException, IllegalStateException {
        this.ensureRowAvailable();
        return this.row == null ? null : this.decoders[indColumn + this.nullBytes].convertToString(this.row[indColumn + this.nullBytes]);
    }

    public boolean isCellNull(int indColumn) throws IndexOutOfBoundsException, IllegalStateException {
        this.ensureRowAvailable();
        int concernedByte = indColumn / 8;
        int positionInByte = 7 - indColumn % 8;
        int intForPosition = (int)Math.pow(2.0, positionInByte);
        int result = Integer.parseInt(this.getCellAsString(concernedByte - this.nullBytes)) & intForPosition;
        return result == intForPosition;
    }

    @Override
    public SavotTD getTD(int indColumn) throws IndexOutOfBoundsException, IllegalStateException {
        this.ensureRowAvailable();
        SavotTD td = new SavotTD();
        td.setContent(this.getCellAsString(indColumn));
        return td;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
        this.data = null;
        this.row = null;
        this.decoders = null;
    }
}

